<?php
session_start(); // Sesssion 

try {
    // Connect to SQLite database
   $my_conn = new PDO('sqlite:'.dirname(__FILE__).'/plus2net_users.db'); // Inside the same directory 

    // Get the form data
    $userid = $_POST['userid'];
    $password = $_POST['password'];

    // Prepare the SQL statement to check for the user
    $stmt = $my_conn->prepare("SELECT * FROM users WHERE userid = :userid AND password = :password");

    // Bind parameters
    $stmt->bindParam(':userid', $userid);
    $stmt->bindParam(':password', $password);  // Assuming password is stored as plain text for this example. Use hashing in production.
   
    $stmt->execute();  // Execute the query

    $user = $stmt->fetch(PDO::FETCH_ASSOC);     // Fetch the result

    // Check if a matching user was found
    if ($user) {
        // User found, create session
        $_SESSION['userid'] = $user['userid'];
        $_SESSION['email'] = $user['email'];

        echo "<h2>Welcome, " . htmlspecialchars($user['userid']) . "!</h2>";
    } else {
        // Invalid credentials
        echo "<h2>Login Failed. Invalid User ID or Password.</h2>";
    }

} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
}
?>
